% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readNWISpCode}
\alias{readNWISpCode}
\title{USGS Parameter Data Retrieval}
\usage{
readNWISpCode(parameterCd)
}
\arguments{
\item{parameterCd}{character of USGS parameter codes (or multiple parameter codes).  This is usually an 5 digit number.}
}
\value{
parameterData data frame with all information from the USGS about the particular parameter.

\tabular{lll}{
  Name \tab Type \tab Description\cr
  parameter_cd \tab character \tab 5-digit USGS parameter code \cr
  parameter_group_nm \tab character \tab USGS parameter group name\cr
  parameter_nm \tab character \tab USGS parameter name\cr
  casrn \tab character \tab Chemical Abstracts Service (CAS) Registry Number\cr
  srsname \tab character \tab Substance Registry Services Name\cr
  parameter_units \tab character \tab Parameter units\cr
}
}
\description{
Imports data from NWIS about meaured parameter based on user-supplied parameter code.
This function gets the data from here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes}
}
\examples{
paramINFO <- readNWISpCode(c('01075','00060','00931'))
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

