% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISData}
\alias{getNWISData}
\alias{readNWISdata}
\title{General Data Import from NWIS}
\usage{
getNWISData(service = "dv", ...)

readNWISdata(service = "dv", ...)
}
\arguments{
\item{service}{string. Possible values are "iv" (for instantaneous), "dv" (for daily values), "gwlevels"
(for groundwater levels), and "qwdata" (for water quality)}

\item{\dots}{see \url{http://waterservices.usgs.gov/rest/Site-Service.html#Service} for a complete list of options}
}
\value{
retval dataframe
}
\description{
Returns data from the NWIS web service.
Arguments to the function should be based on \url{http://waterservices.usgs.gov} service calls.
}
\examples{
\dontrun{
# Examples not run for time considerations
dataTemp <- readNWISdata(stateCd="OH",parameterCd="00010")
dataTempUnit <- readNWISdata(sites="03086500", service="iv", parameterCd="00010")
#Empty:
multiSite <- readNWISdata(sites=c("04025000","04072150"), service="iv", parameterCd="00010")
#Not empty:
multiSite <- readNWISdata(sites=c("04025500","040263491"), service="iv", parameterCd="00060")
}
}
\keyword{NWIS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

