% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISDaily}
\alias{getNWISDaily}
\title{Import NWIS Daily Data for EGRET analysis}
\usage{
getNWISDaily(siteNumber, parameterCd, startDate, endDate, interactive = TRUE,
  convert = TRUE, format = "tsv")
}
\arguments{
\item{siteNumber}{string USGS site number.  This is usually an 8 digit number}

\item{parameterCd}{string USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}

\item{convert}{logical Option to include a conversion from cfs to cms (35.314667). The default is TRUE,
which is appropriate for using NWIS data in the EGRET package.  Set this to FALSE to not include the conversion. If the parameter code is not 00060 (NWIS discharge),
there is no conversion applied.}

\item{format}{string, can be "tsv" or "xml", and is only applicable for daily and unit value requests.  "tsv" returns results faster, but there is a possiblitiy that an incomplete file is returned without warning. XML is slower,
but will offer a warning if the file was incomplete (for example, if there was a momentary problem with the internet connection). It is possible to safely use the "tsv" option,
but the user must carefully check the results to see if the data returns matches what is expected. The default is "tsv".}
}
\value{
Daily dataframe
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{http://waterservices.usgs.gov/}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
# These examples require an internet connection to run
Daily <- getNWISDaily('01594440','00060', '1985-01-01', '1985-03-31')
DailyCFS <- getNWISDaily('01594440','00060', '1985-01-01', '1985-03-31',convert=FALSE)
DailySuspSediment <- getNWISDaily('01594440','80154', '1985-01-01', '1985-03-31')
}
\seealso{
\code{\link{getNWISdvData}}, \code{\link{populateDaily}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

