% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Produce distribution plots}
\usage{
visualize(v, vnam = NULL, visuals = setVisuals(), doEval = TRUE, ...)
}
\arguments{
\item{v}{The variable (vector) or dataset (data.frame) which is to be plotted.}

\item{vnam}{The name of the variable. This name might be printed on the plots, depending on the
choice of plotting function. If not supplied, it will default to the name of \code{v}.}

\item{visuals}{A list of visual functions to use on each supported variable type. We recommend
using \code{\link{setVisuals}} for creating this list and refer to the documentation
of this function for more details. This function allows for choosing variable-type dependent 
visuals. However, if \code{visualize()} is called on a full dataset, all visualizations
must be of the same type and therefore, the \code{all} argument of \code{setVisuals} is used.}

\item{doEval}{A logical. If \code{TRUE} (the default), \code{visualize} has the side effect of
producing a plot (or multiple plots, if \code{v} is a data.frame). Otherwise,
visualize returns a character string containing R-code for producing the plot (or, when \code{v} is
a data.frame, a list of such character strings).}

\item{...}{Additional arguments used for class-specific choices of visual functions 
(see \emph{details}).}
}
\description{
Generic shell function that calls a plotting function in order to produce a marginal
distribution plot for a variable (or for each variable in a dataset). What type of plot is made 
might depend on the data class of the variable.
}
\details{
Visual functions can be  supplied using their names (in character strings) using
\code{setVisuals}. Note that only a single visual function is allowed for each variable class.
The default visual settings can be inspected by calling \code{setVisuals()}.  
An overview of all available \code{visualFunction}s can be obtained by calling
\code{\link{allVisualFunctions}}. 

A user defined visual function can be supplied using its function name. Details on how 
to construct valid visual functions are found in \code{\link{visualFunction}}.
}
\examples{
 #Standard use: Return standalone code for plotting a function:
   visualize(c(1:10), "Variable 1", doEval = FALSE)

 #Define a new visualization function and call it using visualize either
 #using allVisual or a class specific argument:
   mosaicVisual <- function(v, vnam, doEval) {
     thisCall <- call("mosaicplot", table(v), main = vnam, xlab = "")
     if (doEval) {
       return(eval(thisCall))
     } else return(deparse(thisCall))
   }
   mosaicVisual <- visualFunction(mosaicVisual, 
                                  description = "Mosaicplots from graphics",
                                  classes = allClasses())
  
  #Inspect all options for visualFunctions:
  allVisualFunctions()


 \dontrun{
   #set mosaicVisual for all variable types:
   visualize(c("1", "1", "1", "2", "2", "a"), "My variable", 
       visuals = setVisuals(all = "mosaicVisual"))

   #set mosaicVisual only for character variables:
   visualize(c("1", "1", "1", "2", "2", "a"), "My variable", 
      visuals = setVisuals(character = "mosaicVisual"))

   #this will use standardVisual, as our variable is not numeric:
   visualize(c("1", "1", "1", "2", "2", "a"), "My variable", 
       visuals = setVisuals(numeric = "mosaicVisual"))
 }

   #return code for a mosaic plot
   visualize(c("1", "1", "1", "2", "2", "a"), "My variable", 
       allVisuals = "mosaicVisual", doEval=FALSE)

 \dontrun{
 #Produce multiple plots easily by calling visualize on a full dataset:
   data(testData)
   testData2 <- testData[, c("charVar", "factorVar", "numVar", "intVar")]
   visualize(testData2)
   
 #When using visualize on a dataset, datatype specific arguments have no
 #influence:
   visualize(testData2, setVisuals(character = "basicVisual", 
       factor = "basicVisual"))
   
 #But we can still use the "all" argument in setVisuals:
   visualize(testData2, visuals =  setVisuals(all = "basicVisual"))
 }

}
\references{
Petersen AH, Ekstrøm CT (2019). “dataMaid: Your Assistant for Documenting Supervised Data Quality Screening in R.” _Journal of Statistical Software_, *90*(6), 1-38. doi: 10.18637/jss.v090.i06 ( \doi{10.18637/jss.v090.i06}).
}
\seealso{
\code{\link{setVisuals}}, \code{\link{allVisualFunctions}},
\code{\link{standardVisual}}, \code{\link{basicVisual}}
}
