% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{validate_cols}
\alias{validate_cols}
\title{Validation on columns}
\usage{
validate_cols(
  data,
  predicate,
  ...,
  obligatory = FALSE,
  description = NA,
  skip_chain_opts = FALSE,
  success_fun = assertr::success_append,
  error_fun = assertr::error_append,
  defect_fun = assertr::defect_append
)
}
\arguments{
\item{data}{A data.frame or tibble to test}

\item{predicate}{Predicate function or predicate generator such as \code{\link[assertr]{in_set}}
or \code{\link[assertr]{within_n_sds}}}

\item{...}{Columns selection that \code{predicate} should be called on.
All tidyselect \code{\link[tidyselect]{language}} methods are supported.
If not provided, all \code{\link[tidyselect]{everything}} will be used.}

\item{obligatory}{If TRUE and assertion failed the data is marked as defective.
For defective data, all the following rules are handled by defect_fun function}

\item{description}{A character string with description of assertion.
The description is then displayed in the validation report}

\item{skip_chain_opts}{While wrapping data with \link{validate} function, \code{success_fun} and
\code{error_fun} parameters are rewritten with \code{success_append} and \code{error_append}
respectively. In order to use parameters assigned to the function directly set skip_chain_opts
to TRUE}

\item{success_fun}{Function that is called when the validation pass}

\item{error_fun}{Function that is called when the validation fails}

\item{defect_fun}{Function that is called when the data is marked as defective}
}
\description{
Validation on columns
}
\seealso{
validate_if validate_rows
}
