% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2bayescan.r
\name{gl2bayescan}
\alias{gl2bayescan}
\title{Converts a genlight object into a format suitable for input to Bayescan}
\usage{
gl2bayescan(x, outfile = "bayescan.txt", outpath = tempdir(), verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file (including extension)
[default bayescan.txt].}

\item{outpath}{Path where to save the output file
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.'
when calling this function to direct output files to your working directory.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\description{
The output text file contains the SNP data and relevant BAyescan command
 lines to guide input.
}
\examples{
out <- gl2bayescan(testset.gl)
}
\references{
Foll M and OE Gaggiotti (2008) A genome scan method to identify selected loci
 appropriate for both dominant and codominant markers: A Bayesian
  perspective. Genetics 180: 977-993.
}
\author{
Custodian: Luis Mijangos (Post to
\url{https://groups.google.com/d/forum/dartr})
}
