% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.edit.recode.pop.r
\name{gl.edit.recode.pop}
\alias{gl.edit.recode.pop}
\title{Create or edit a population re-assignment table}
\usage{
gl.edit.recode.pop(gl, pop.recode = NULL)
}
\arguments{
\item{gl}{Name of the genlight object for which populations are to be reassigned.[required]}

\item{pop.recode}{Name of the file to output the new assignments [optional]}
}
\value{
An object of class ("genlight") with the revised population assignments
}
\description{
A script to edit population assignments in a genlight object, or to 
create a reassignment table taking the population assignments
from a genlight object, or to edit existing population assignments in
a pop.recode.table.
}
\details{
Genlight objects assign specimens to populations based on information in the
ind.metadata file provided when the genlight object is first generated.
Often one wishes to subset the data by deleting populations or to amalgamate
populations. This can be done with a pop.recode table with two columns. The
first column is the population assignment in the genlight object, the second
column provides the new assignment.

This script will input an existing reassignment table for editting and
optionally save it as a new table, or if the name of an input table is not
supplied, will generate a table using the population assignments in the 
parent genlight object.

The script, having deleted populations, identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r)

The script returns a genlight object with the new population assignments.
}
\examples{
\dontrun{
gl <- gl.edit.recode.pop(gl)
gl <- gl.edit.recode.pop(gl, pop.recode="pop.recode.table.csv")
gl <- gl.edit.recode.pop(gl, pop.recode="pop.recode.table.csv", 
pop.recode.new="recode.table.minus.hybrids.csv")
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
