% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.read.dart.r
\name{gl.read.dart}
\alias{gl.read.dart}
\title{Import DarT data into R and conver it to a genlight object}
\usage{
gl.read.dart(filename, covfilename = NULL, nas = "-", topskip = NULL,
  stdmetrics = c("AlleleID", "SNP", "SnpPosition", "RepAvg", "CallRate",
  "AvgCountRef", "AvgCountSnp", "FreqHomRef", "FreqHomSnp", "FreqHets",
  "OneRatioSnp"), addmetrics = NULL, lastmetric = "RepAvg", probar = TRUE)
}
\arguments{
\item{filename}{path to file (csv file only currently)}

\item{covfilename}{the name of the file that has entails additional information on individuals. For the require format check}

\item{nas}{a character specifying NAs (default is "-")}

\item{topskip}{a number specifying the number of rows to be skipped. If not provided the number of rows to be skipped are "guessed" by the number of rows with "*" at the beginning.}

\item{stdmetrics}{a vector of column headings that are extracted. AlleleID and its format is compulsory, the rest are needed for filtering.}

\item{addmetrics}{add additional headers/columns by name}

\item{lastmetric}{specifies the last non genetic column (Default is "RepAvg"). Be sure to check if that is true, otherwise the number of individuals will not match. You can also specify the last column by a number.}

\item{probar}{show progress bar}
}
\value{
a dart genlight object that contains individuals [if data were provided] and loci meta data [from a DArT report]. The dart genlight object can then be fed into a number of initial screening, export and export functions provided by the package. For some of the function it is necessary to have the metadata that was provided from DArT. Please check the vignette for more information. Additional information can also be found in the help documents for  \code{\link{read.dart}} and \code{\link{dart2genlight}}.
}
\description{
This function is a wrapper function that allows you to convert you dart file into a genlight object in one step. In previous versions you had to use read.dart and then dart2genlight. In case you have individual metadata for each individual/sample you can specify as before in the dart2genlight command the file that combines the data.
}
\examples{
{
dartfile <- system.file("extdata","testset_SNPs_2Row.csv", package="dartR")
covfilename <- system.file("extdata","testset_metadata.csv", package="dartR")
gl <- gl.read.dart(dartfile, covfilename = covfilename, probar=TRUE)
}
}

