% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.maf.r
\name{gl.report.maf}
\alias{gl.report.maf}
\title{Reports minor allele frequency (MAF) for each locus in a SNP dataset}
\usage{
gl.report.maf(
  x,
  maf.limit = 0.5,
  ind.limit = 5,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.dir = NULL,
  plot.file = NULL,
  bins = 25,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{maf.limit}{Show histograms MAF range <= maf.limit [default 0.5].}

\item{ind.limit}{Show histograms only for populations of size greater than
ind.limit [default 5].}

\item{plot.display}{Specify if plot is to be displayed in the graphics window [default TRUE].}

\item{plot.theme}{User specified theme [default theme_dartR()].}

\item{plot.colors}{Vector with color names for the borders and fill
[default c("#2171B5", "#6BAED6")].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{plot.file}{Filename (minus extension) for the RDS plot file [Required for plot save]}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
An unaltered genlight object
}
\description{
This script provides summary histograms of MAF for each
population and an overall histogram to assist the decision of
choosing thresholds for the filter function \code{\link{gl.filter.maf}}
}
\details{
The function \code{\link{gl.filter.maf}} will filter out the
 loci with MAF below a specified threshold.
\strong{ Function's output }
 The minimum, maximum, mean and a tabulation of MAF quantiles against
 thresholds rate are provided. Output also includes a boxplot and a
 histogram.
 This function reports the
 MAF for each of several quantiles. Quantiles are
 partitions of a finite set of values into q subsets of (nearly) equal sizes.
 In this function q = 20. Quantiles are useful measures because they are less
 susceptible to long-tailed distributions and outliers.
 
 Plot colours can be set with gl.select.colors().
 
  If plot.file is specified, plots are saved to the directory specified by the user, or the global
  default working directory set by gl.set.wd() or to the tempdir().

Examples of other themes that can be used can be consulted in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\seealso{
\code{\link{gl.filter.maf}}

Other matched report: 
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges (Post to 
\url{https://groups.google.com/d/forum/dartr})
}
\concept{matched report}
