% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.drop.loc.r
\name{gl.drop.loc}
\alias{gl.drop.loc}
\title{Removes specified loci from a dartR genlight object}
\usage{
gl.drop.loc(x, loc.list = NULL, first = NULL, last = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{loc.list}{A list of loci to be deleted
[required, if loc.range not specified].}

\item{first}{First of a range of loci to be deleted
[required, if loc.list not specified].}

\item{last}{Last of a range of loci to be deleted
[if not specified, last locus in the dataset].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress but not results; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A reduced dartR genlight object
}
\description{
This function deletes individuals and their associated metadata. 
The script returns a dartR genlight object with the retained loci. 
The script works with both genlight objects
containing SNP genotypes and Tag P/A data (SilicoDArT).
}
\examples{
# SNP data
  gl2 <- gl.drop.loc(testset.gl, loc.list=c('100051468|42-A/T', '100049816-51-A/G'),verbose=3)
# Tag P/A data
  gs2 <- gl.drop.loc(testset.gs, loc.list=c('20134188','19249144'),verbose=3)
  
}
\seealso{
\code{\link{gl.keep.loc}} to keep rather than drop specified loci

Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sort}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
