% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/detect_conditional_activity_presence_violations.R
\name{detect_conditional_activity_presence}
\alias{detect_conditional_activity_presence}
\title{Detect conditional activity presence violations}
\usage{
detect_conditional_activity_presence(activitylog, condition, activities,
  details, filter_condition)
}
\arguments{
\item{activitylog}{The activity log}

\item{condition}{Condition which serve as an antecedent (if the condition in condition holds, then the activit(y)(ies) in activities should be present.)}

\item{activities}{Vector of activity/activities which serve as a consequent (if the condition(s) in condition_vector hold, then the activity/activities in activity_vector should be recorded)}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
Numeric vector containing the case identifiers of cases for which the specified conditional activity presence is violated
}
\description{
Function detecting violations of conditional activity presence (i.e. an activity/activities that should be present when (a) particular condition(s) hold(s))
}
\examples{
\donttest{
data("hospital_actlog")
detect_conditional_activity_presence(activitylog = hospital_actlog,
     condition = specialization == "TRAU",
     activities = "Clinical exam")
}

}
