% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R, R/formatting_drift_dm.R
\name{drift_dm}
\alias{drift_dm}
\alias{print.drift_dm}
\title{Create a drift_dm object}
\usage{
drift_dm(
  prms_model,
  conds,
  subclass,
  instr = NULL,
  obs_data = NULL,
  sigma = 1,
  t_max = 3,
  dt = 0.001,
  dx = 0.001,
  solver = "kfe",
  mu_fun = NULL,
  mu_int_fun = NULL,
  x_fun = NULL,
  b_fun = NULL,
  dt_b_fun = NULL,
  nt_fun = NULL,
  b_coding = NULL
)

\method{print}{drift_dm}(x, ..., round_digits = drift_dm_default_rounding())
}
\arguments{
\item{prms_model}{a named numeric vector of the model parameters. The names
indicate the model's parameters, and the numeric entries provide the current
parameter values.}

\item{conds}{a character vector, giving the names of the model's conditions.
values within \code{conds} will be used when addressing the data and when
deriving the model's predictions.}

\item{subclass}{a character string, with a name for the newly created
diffusion model (e.g., \code{dmc_dm}). This will be the child class.}

\item{instr}{an optional character string, providing "instructions" for the
underlying \link{flex_prms} object.}

\item{obs_data}{an optional data.frame, providing a data set (see
\code{\link[=obs_data]{obs_data()}} for more information).}

\item{sigma}{the diffusion constant. Default is \code{1}.}

\item{t_max}{the maximum of the time space. Default is set \code{3} (seconds).}

\item{dt, dx}{the step size of the time and evidence space discretization,
respectively. Default is set to \code{.001} (which refers to seconds for dt).
Note that these values are set conservatively per default. In many cases,
users can increase the discretization.}

\item{solver}{a character string, specifying which approach to use for
deriving the first passage time. Default is \code{kfe}, which provides access to
the numerical discretization of the Kolmogorov Forward Equation.}

\item{mu_fun, mu_int_fun, x_fun, b_fun, dt_b_fun, nt_fun}{Optional custom
functions defining the components of a diffusion model. See
\code{\link[=comp_funs]{comp_funs()}}. If an argument is \code{NULL}, dRiftDM falls
back to the respective default functions, which are documented in
\code{\link[=comp_funs]{comp_funs()}}.}

\item{b_coding}{an optional list, specifying how boundaries are coded. See
\code{\link[=b_coding]{b_coding()}}. Default refers to accuracy coding.}

\item{x}{an object of type \code{drift_dm}}

\item{...}{additional parameters}

\item{round_digits}{integer, controls the number of digits shown for
\code{\link[=print.drift_dm]{print.drift_dm()}}. Default is \code{3}.}
}
\value{
For \code{drift_dm()}, a list with the parent class label \code{"drift_dm"}
and the child class label \verb{<subclass>}. The list contains the following
entries:
\itemize{
\item An instance of the class \link{flex_prms} for controlling the model
parameters. Provides information about the number of parameters, conditions
etc.
\item Parameters used for deriving the model predictions, \link{prms_solve},
containing the diffusion constant (\code{sigma}), the maximum of the time space
(\code{t_max}), the evidence and space discretization (\code{dt} and \code{dx},
respectively), and the resulting number of steps for the time and evidence
space discretization (\code{nt} and \code{nx}, respectively).
\item A character string \code{solver}, indicating the method for deriving the model
predictions.
\item A list of functions called \link{comp_funs}, providing the components
of the diffusion model (i.e., \code{mu_fun}, \code{mu_int_fun}, \code{x_fun}, \code{b_fun},
\code{dt_b_fun}, \code{nt_fun}). These functions are called in the depths of the
package and will determine the behavior of the model
}

If (optional) observed data were passed via \code{\link[=obs_data]{obs_data()}},
the list will contain an entry \code{obs_data}. This is a (nested) list with
stored response times for the upper and lower boundary and with respect to
each condition.

If the model has been evaluated (see \code{\link[=re_evaluate_model]{re_evaluate_model()}}), the
list will contain...
\itemize{
\item ... the log likelihood; can be addressed via \code{\link[=logLik.drift_dm]{logLik.drift_dm()}}.
\item ... the PDFs of the first passage time; can be addressed via
\code{\link[=pdfs]{pdfs()}}.
}

Finally, if arbitrary R objects were passed via \code{\link[=ddm_opts]{ddm_opts()}}, to
access these objects when evaluating the component functions, the list will
contain an entry \code{ddm_opts}.

Every model also has the attribute \link{b_coding}, which summarizes how
the boundaries are labeled.

For \code{print.drift_dm()}, the supplied \code{drift_dm} object \code{x} (invisible return).
}
\description{
This function creates an object of type drift_dm, which serves as the parent
class for all further created drift diffusion models (all of which have
a child class label, e.g., \code{dmc_dm}). The objects created by \code{drift_dm()} are
the backbone of the dRiftDM package. For a list of all pre-built models, see
\code{vignette("dRiftDM", "dRiftDM")}.
}
\details{
To modify the entries of a model users can use the replacement methods and
the \code{\link[=modify_flex_prms]{modify_flex_prms()}} method (see also
\code{vignette("dRiftDM", "dRiftDM")} and
\code{vignette("customize_ddms", "dRiftDM")}).
}
\examples{
# Plain call, with default component functions -----------------------------
# create parameter and condition vectors
prms <- c(muc = 4, b = 0.5)
conds <- c("one", "two")

# then call the backbone function (note that we don't provide any component
# functions, so dRiftDM uses the default functions as documented in
# comp_funs())
my_model <- drift_dm(prms_model = prms, conds = conds, subclass = "example")
print(my_model)

}
\seealso{
\code{\link[=conds]{conds()}}, \code{\link[=flex_prms]{flex_prms()}}, \code{\link[=prms_solve]{prms_solve()}},
\code{\link[=solver]{solver()}}, \code{\link[=obs_data]{obs_data()}}, \code{\link[=comp_funs]{comp_funs()}},
\code{\link[=b_coding]{b_coding()}}, \code{\link[=coef]{coef()}}, \code{\link[=pdfs]{pdfs()}}
}
