% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{defaults}
\alias{defaults}
\alias{drift_dm_approx_error}
\alias{drift_dm_medium_approx_error}
\alias{drift_dm_small_approx_error}
\alias{drift_dm_rough_approx_error}
\alias{drift_dm_robust_prm}
\alias{drift_dm_default_rounding}
\alias{drift_dm_default_probs}
\alias{drift_dm_default_b_coding}
\title{Default Values for the dRiftDM Package}
\usage{
drift_dm_approx_error()

drift_dm_medium_approx_error()

drift_dm_small_approx_error()

drift_dm_rough_approx_error()

drift_dm_robust_prm()

drift_dm_default_rounding()

drift_dm_default_probs()

drift_dm_default_b_coding()
}
\value{
the respective values/lists as described in the Details section
}
\description{
These functions provide default values for various settings in the
\code{dRiftDM} package.
}
\details{
\itemize{
\item \code{drift_dm_approx_error()}: Returns the default approximation error
for precise calculations (1e-20).
\item \code{drift_dm_medium_approx_error()}: Returns a 'medium' level of approximation
error (1e-04).
\item \code{drift_dm_small_approx_error()}: Returns a 'small' level of approximation
error (.01).
\item \code{drift_dm_rough_approx_error()}: Returns a rough level of approximation
error (.1).
\item \code{drift_dm_robust_prm()}: Returns a value that is added to the PDFs after
convolution with the non-decision time to make parameter estimation and the
evaluation of the log-likelihood more robust (1e-10).
\item \code{drift_dm_default_rounding()}: Returns the default rounding precision for
numerical outputs (3).
\item \code{drift_dm_default_probs()}: Returns the default sequence of probabilities
for quantiles (0.1, 0.2, ..., 0.9)
\item \code{drift_dm_default_b_coding()}: Returns the default boundary coding
(list(column = "Error", u_name_value = c("corr" = 0),
l_name_value = c("err" = 1))
}
}
\keyword{internal}
