% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.clustering_part1.R
\name{centers_data}
\alias{centers_data}
\alias{plot.centers_data}
\title{Prediction of clusters centroid position}
\usage{
centers_data(sample.subquality, sample.table, referenceDB)

\method{plot}{centers_data}(x, ..., sample = "all")
}
\arguments{
\item{sample.subquality}{an object of class \code{read_sample}, inherited
from \code{\link{read_sample}}.}

\item{sample.table}{object of class \code{sample_table}, inherited from
\code{\link{read_sampleTable}}.}

\item{referenceDB}{an object of class \code{reference_dbscan}, inherited
from \code{\link{reference_dbscan}}}

\item{x}{an object of class \code{centers_data}}

\item{...}{Arguments to be passed to methods}

\item{sample}{'all' to show all samples, or a numeric vector indicating
the row number of samples in the sample table.}
}
\value{
An object of class \code{centers_data} containing a sublist for
  each sample. Each sublist has the following components:
  \item{quality}{quality threshold used in \code{\link{read_sample}}.}
  \item{reference}{reference ID.}
  \item{centers}{a data frame with the centroids coordinates.}
  \item{data}{a data frame with the fluorescence intensities.}
}
\description{
This function calculates the coodintaes of all clusters centroid.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata",package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)

#Read samples files
samp <- read_sample(sample.table, system = "bio-rad",
                    file.location = fileLoc)

#Reference DBSCAN clustering
dbref <- reference_dbscan(ref, sample.table, save.template = FALSE)

#Predict position of clusters centroid from reference DBSCAN results
cent <- centers_data(samp, sample.table,dbref)

plot(cent, sample = "all")
}
}
