% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{coordTransform}
\alias{coordTransform}
\title{Coordinate transformation for data frames}
\usage{
coordTransform(data, transformations)
}
\arguments{
\item{data}{data frame with at least columns "name" (character) and
"value" (numeric). Can optionally contain a column "sigma" (numeric).}

\item{transformations}{character (the transformation) or named list of
characters. In this case, the list names must be a subset of those 
contained in the "name" column.}
}
\value{
The data frame with the transformed values and sigma uncertainties.
}
\description{
Applies a symbolically defined transformation to the \code{value}
column of a data frame. Additionally, if a \code{sigma} column is
present, those values are transformed according to Gaussian error
propagation.
}
\examples{
mydata1 <- data.frame(name = c("A", "B"), time = 0:5, value = 0:5, sigma = .1)
coordTransform(mydata1, "log(value)")
coordTransform(mydata1, list(A = "exp(value)", B = "sqrt(value)"))
}
