% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{timetoeventprediction}
\alias{timetoeventprediction}
\title{Example fitted time to event prediction}
\format{
An object of class \code{list} of length 6.
}
\usage{
data(timetoeventprediction)
}
\description{
Example fitted time to event prediction
}
\examples{
\donttest{
## Code that generates this object - following example in vignette
set.seed(10)
T.morts.sim <- simulate_cycloSurv(300, period = 365, meanhazard = 1/365, 
peaks = c(100, 250), durations = c(25, 40), weights = c(0.4, 0.6), plotme = FALSE)
T.morts.fit <- fit_cyclomort(T.morts.sim, n.seasons = 2)
timetoeventprediction <- predict(T.morts.fit, t = 1:365, 
                                 type = "timetoevent", CI = TRUE, nreps = 100)
}
data(timetoeventprediction)
with(timetoeventprediction, {
plot(t, fit, type = "l", ylab = "Time to event", ylim = range(CI), lwd = 2)
lines(t, CI[1,])
lines(t, CI[2,])})
}
\keyword{data}
