% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{seasonalsex}
\alias{seasonalsex}
\title{Simulated data of seasonal mortality data for two sex groups}
\format{
Simulated data of single-season mortalities for two sex groups:
\describe{
  \item{sex}{female (F) or male (M)}
  \item{event}{\code{cycloSurv} object of (censored) survival data}
}
}
\usage{
data(seasonalsex)
}
\description{
See examples below for the process of simulating and visualizing these data 
using \code{\link{simulate_cycloSurv}}, and an example of analyzing these 
data with \code{\link{factorfit_cyclomort}}.
}
\examples{
# useful packages
require(ggplot2); require(magrittr); require(plyr)

# Example of simulating multi-factor data:
## Not run:** 
n <- 100
T.male = simulate_cycloSurv(n, period = 1, meanhazard = 0.3, peaks = .25, durations = .3)
T.female = simulate_cycloSurv(n, period = 1, meanhazard = 0.3, peaks = .75, durations = .3)
T.joint <- with(rbind(T.male, T.female) \%>\% data.frame,
          create_cycloSurv(start = start, end = stop, 
                           event = status, period = 1))
seasonalsex <- data.frame( sex = rep(c("M","F"), each = n), T = T.joint)
## End(**Not run**)

# load and visualize simulated sex-specific survival data
data("seasonalsex")

seasonsex.df <- cbind(seasonalsex, as.matrix(seasonalsex$event) \%>\% as.data.frame) \%>\%
  arrange(sex,stop) \%>\% mutate(id = 1:length(start) \%>\% factor, 
                               status = c("Dead", "Censored")[2-status])

require(ggplot2)
ggplot(seasonsex.df, aes(x = start, y = id, col = status)) + 
  geom_errorbarh(aes(xmin = start, xmax = stop)) + 
  facet_wrap(.~sex, scales = "free_y", ncol = 1) + 
  ggtitle("Simulated sex-specific mortality data")

seasonsex.df$time.trunc <- with(seasonsex.df, stop - floor(stop))
with(seasonsex.df, {
  hist(time.trunc[sex == "M"], col = rgb(0,0,1,.3), breaks = seq(0,1,.1), 
       bor = NA, freq = FALSE, xlab = "Time (within period)", 
       main = "Male vs. Female (simulated) mortalities")  
  hist(time.trunc[sex == "F"], col = rgb(1,0,0,.3), breaks = seq(0,1,.1), 
       bor = NA, add = TRUE, freq = FALSE)  
  lines(density(time.trunc[sex == "M"], from = 0, to = 1), col = "darkblue", lwd = 2)
  lines(density(time.trunc[sex == "F"], from = 0, to = 1), col = "darkred", lwd = 2)
  legend("topleft", fill = c("blue", "red"), legend = c("M","F"), title = "Sex")
})

# test differences

sex.fit <- factorfit_cyclomort(event ~ sex, data = seasonalsex, n.seasons = 1)
summary(sex.fit)
\donttest{
plot(sex.fit, ymax = 1.3)
}
}
\keyword{data}
