% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_multi.R
\name{batch_multi}
\alias{batch_multi}
\title{Batch routing for multiple plans and large datasets}
\usage{
batch_multi(
  desire_lines,
  plans = c("fastest", "balanced"),
  nrow_batch = 10000,
  temp_folder = tempdir(),
  batch_ids = NULL,
  ...
)
}
\arguments{
\item{desire_lines}{Input desire lines}

\item{plans}{Plans, e.g. fastest}

\item{nrow_batch}{How many rows per batch?}

\item{temp_folder}{path to folder}

\item{batch_ids}{NULL?}

\item{...}{Arguments passed to batch}
}
\value{
A list of routes.
}
\description{
Batch routing for multiple plans and large datasets
}
\examples{
if(FALSE) {
od_df = readr::read_csv("https://github.com/nptscot/npt/raw/main/data-raw/od_subset.csv")
zones = sf::read_sf("https://github.com/nptscot/npt/raw/main/data-raw/zones_edinburgh.geojson")
desire_lines = od::od_to_sf(od_df, zones)
desire_lines = desire_lines[1:100, ]
p = c("fastest", "quietest")
routes_multi = batch_multi(desire_lines, plans = p, nrow_batch = 26, delete_job = FALSE)
names(routes_multi)
plot(routes_multi$fastest$geometry)
plot(routes_multi$quietest$geometry)
ids = list(
  fastest = 4059:(4059+3),
  quietest = 4063:(4063+3)
)
r_ids = batch_multi(desire_lines, plans = p, nrow_batch = 26, delete_job = FALSE, batch_ids = ids)
}
}
