% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey2.R
\name{json2sf_cs}
\alias{json2sf_cs}
\title{Quickly convert output from CycleStreets.net into sf object}
\usage{
json2sf_cs(
  results_raw,
  id = 1,
  segments = TRUE,
  route_variables = c("start", "finish", "start_longitude", "start_latitude",
    "finish_longitude", "finish_latitude", "crow_fly_distance", "event", "whence",
    "speed", "itinerary", "plan", "note", "length", "west", "south", "east", "north",
    "leaving", "arriving", "grammesCO2saved", "calories", "edition"),
  cols_to_keep = c("id", "time", "busynance", "quietness", "signalledJunctions",
    "signalledCrossings", "name", "walk", "elevations", "distances", "type", "legNumber",
    "distance", "turn", "startBearing", "color", "provisionName", "start", "finish",
    "start_longitude", "start_latitude", "finish_longitude", "finish_latitude",
    "crow_fly_distance", "event", "whence", "speed", "itinerary", "plan", "note",
    "length", "west", "south", "east", "north", "leaving", "arriving", "grammesCO2saved",
    "calories", "edition", "gradient_segment", 
     "elevation_change",
    "gradient_smooth")
)
}
\arguments{
\item{results_raw}{Raw result from CycleStreets.net read-in with readLines or similar}

\item{id}{id of the result}

\item{segments}{Return segment level data? TRUE by default.}

\item{route_variables}{Route level variables}

\item{cols_to_keep}{Columns to return in output sf object}
}
\description{
Available fields from CycleStreets include:
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{c("id", "time", "busynance", "quietness", "signalledJunctions",
  "signalledCrossings", "name", "walk", "elevations", "distances",
  "type", "legNumber", "distance", "turn", "startBearing", "color",
  "provisionName", "start", "finish", "start_longitude", "start_latitude",
  "finish_longitude", "finish_latitude", "crow_fly_distance", "event",
  "whence", "speed", "itinerary", "plan", "note", "length", "west",
  "south", "east", "north", "leaving", "arriving", "grammesCO2saved",
  "calories", "edition", "gradient_segment", "elevation_change",
  "gradient_smooth", "geometry")
}\if{html}{\out{</div>}}
}
\examples{
from = "Leeds Rail Station"
to = "University of Leeds"
# from_point = tmaptools::geocode_OSM(from)
# to_point = tmaptools::geocode_OSM(to)
from_point = c(-1.54408, 53.79360)
to_point =   c(-1.54802, 53.79618)
# save result from the API call to journey.json
# res_json = journey(from_point, to_point, silent = FALSE, save_raw = TRUE)
# jsonlite::write_json(res_json, "inst/extdata/journey.json")
# f = "inst/extdata/journey.json"
f = system.file(package = "cyclestreets", "extdata/journey.json")
rsf = json2sf_cs(readLines(f), id = 1, segments = TRUE)
names(rsf)
json2sf_cs(readLines(f), id = 1, segments = TRUE, cols_to_keep = "quietness")
# save result from the API call to journey.json
# res_json = journey(from_point, to_point, silent = FALSE, save_raw = TRUE)
# jsonlite::write_json(res_json, "inst/extdata/journey_short.json")
# f = "inst/extdata/journey_short.json"
f = system.file(package = "cyclestreets", "extdata/journey_short.json")
obj = jsonlite::read_json(f, simplifyVector = TRUE)
# Inclusion of "start_longitude" leads to the additional ProvisionName1 colum:
cols = c("name", "distances", "provisionName")
json2sf_cs(readLines(f), id = 1, segments = TRUE, cols_to_keep = cols)
}
