\name{r2B}
\alias{roundB}
\alias{r2B}
\alias{r2Be}
\alias{strB2r}
\alias{strB2i}
\title{Conversion of  real to string  and rounding, in given base
}
\description{ Functions for conversion of real to string in given base, and back, fixed and exponential format; and rounding in base number system
}
\usage{
  r2B(x, base = 10, rnd = 0, space = 0, plus = "", lead = "", 
    just = c("right","left","center","none") )
  r2Be(x, base = 10, space = 4,plus = "+",
    just = c("right","left","center","none") )
  roundB( x, base=10, rnd=0 )
  strB2r( STR, base=10 )
  strB2i( STR, base=10 )
}
\arguments{
  \item{x}{Real or integer, vector}
  \item{STR}{Vector of strings representing reals in a given base}
  \item{base}{2 <= integer <= 60, base of representation}
  \item{space}{Integer, space for resulting string;\cr if too small, only necessary space will be taken. All components of the result will be of common length, justified according to 'just'. }
  \item{rnd}{Integer, number of places (after ".") to be rounded;\cr
    = 0: rounded integer, no decimal point;\cr
    = 0.5: rounded integer "." no following digits shown;\cr
    < 0: rounding 'rnd' places *before* last integer digit;\cr
    If too negative, 0 will result; see examples;\cr
    'rnd' prevalent over 'space', i.e. space will be expanded if necessary.}
  \item{plus}{use "+" to show sign for positive values.}
  \item{lead}{use "" or " "; or "0" for leading zeros; this will be inserted after sign.}
  \item{just}{Choice of insertion of justification, can be abbreviated, see \code{\link{justify} } }
}
\value{
  \code{roundB}: vector of arguments rounded to \code{rnd} places according to base \code{base} representation
  
  \code{r2B}: list( s=vector of strings represention of \code{x}, rounded to \code{rnd} decimal digits, base=base)
  
  \code{r2Be}: like \code{r2B}, but in exponential representation, if \code{space} too small. The exponent marker is "e" for \code{base==10} and \code{\link{EXPCHAR}} otherwise.
  \code{strB2r}: real corresponding to string representation. \code{NaN} is returned if \code{str} contains characters not in \code{\link{HexagesDig}[1:base]} (as are generated by \code{r2B}, \code{r2Be} ).

  \code{strB2i}: integer ( str2i ) corresponding to string representation, used in \code{strB2r}
}
\examples{
  x <- c(0,-0.0012345, 1.5234, 543, 8123456,NA,Inf,-Inf,NaN,1,pi)
  y <- c( 0, 1, pi*10^c(-27,-8,0, 8) )
# "+3.1e27" "    NA " "   NaN " "   Inf   )
r2B(x,,space=10,lead=" ",plus="",rnd=3)$s
# "          0 " "-      0.001" "       1.523" "     543.000"
# " 8123456.000" "          NA" "         Inf" "        -Inf"
# "         NaN" "       1.000" "       3.142"
  r2B(x,16,space=10,lead=" ")$s
# "        0 " "-        0" "         2" "       21F"
# "    7BF440" "        NA" "       Inf""      -Inf"
# "       NaN" "         1" "         3"
  r2B( x, 60, 4 )$s
  r2Be( y,10,7)$s
# "     0 " "+1.0000" "+3.e-27" "+3.1e-8" "+3.1416" "+3.14e8"
# "+3.1e27" "    NA " "   NaN " "   Inf "
  strB2r("-    9167.8  4",10)
  strB2r("B00z3",15 )  # 8353125
  (ii <- r2B( 8353125, 32, 4 )$s) # "7UTB5.0000"
  strB2r( ii, 32)  # 8353125
  roundB(c(0.4,0.3),2,16) # 0.39999390 0.30000305
}
\note{
  \code{r2B(.)} and \code{strB2(.)} are inverses of each other.
    
  \code{r2Be} chooses between fixed and exponential format depending on available space, adjusting rounding accordingly. \code{just="left"} works best with \code{lead} = "" = default.
  
  \code{strB2r} can convert strings with exponent signifyers \code{"e"} (for decimals) and \code{"z"} for others, \code{"."} is allowed for fractional parts.

  \code{strB2i} works on strings \emph{without} \code{"e","z","."} ONLY!
}
\author{
  Christian W. Hoffmann <christian@echoffmann.ch>
}
\keyword{character}
