% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosing_metrics_functions.R
\name{binomial_metrics}
\alias{binomial_metrics}
\title{Select metrics for binomial evaluation}
\usage{
binomial_metrics(
  all = NULL,
  balanced_accuracy = NULL,
  accuracy = NULL,
  f1 = NULL,
  sensitivity = NULL,
  specificity = NULL,
  pos_pred_value = NULL,
  neg_pred_value = NULL,
  auc = NULL,
  lower_ci = NULL,
  upper_ci = NULL,
  kappa = NULL,
  mcc = NULL,
  detection_rate = NULL,
  detection_prevalence = NULL,
  prevalence = NULL,
  false_neg_rate = NULL,
  false_pos_rate = NULL,
  false_discovery_rate = NULL,
  false_omission_rate = NULL,
  threat_score = NULL,
  aic = NULL,
  aicc = NULL,
  bic = NULL
)
}
\arguments{
\item{all}{Enable/disable all arguments at once. (Logical)

 Specifying other metrics will overwrite this, why you can
 use (\code{all = FALSE, accuracy = TRUE}) to get only the Accuracy metric.}

\item{balanced_accuracy}{\code{Balanced Accuracy} (Default: TRUE)}

\item{accuracy}{\code{Accuracy} (Default: FALSE)}

\item{f1}{\code{F1} (Default: TRUE)}

\item{sensitivity}{\code{Sensitivity} (Default: TRUE)}

\item{specificity}{\code{Specificity} (Default: TRUE)}

\item{pos_pred_value}{\code{Pos Pred Value} (Default: TRUE)}

\item{neg_pred_value}{\code{Neg Pred Value} (Default: TRUE)}

\item{auc}{\code{AUC} (Default: TRUE)}

\item{lower_ci}{\code{Lower CI} (Default: TRUE)}

\item{upper_ci}{\code{Upper CI} (Default: TRUE)}

\item{kappa}{\code{Kappa} (Default: TRUE)}

\item{mcc}{\code{MCC} (Default: TRUE)}

\item{detection_rate}{\code{Detection Rate} (Default: TRUE)}

\item{detection_prevalence}{\code{Detection Prevalence} (Default: TRUE)}

\item{prevalence}{\code{Prevalence} (Default: TRUE)}

\item{false_neg_rate}{\code{False Neg Rate} (Default: FALSE)}

\item{false_pos_rate}{\code{False Pos Rate} (Default: FALSE)}

\item{false_discovery_rate}{\code{False Discovery Rate} (Default: FALSE)}

\item{false_omission_rate}{\code{False Omission Rate} (Default: FALSE)}

\item{threat_score}{\code{Threat Score} (Default: FALSE)}

\item{aic}{AIC. (Default: FALSE)}

\item{aicc}{AICc. (Default: FALSE)}

\item{bic}{BIC. (Default: FALSE)}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Enable/disable metrics for binomial evaluation. Can be supplied to the
 \code{`metrics`} argument in many of the \code{cvms} functions.

 Note: Some functions may have slightly different defaults than the ones supplied here.
}
\examples{
\donttest{
# Attach packages
library(cvms)

# Enable only Balanced Accuracy
binomial_metrics(all = FALSE, balanced_accuracy = TRUE)

# Enable all but Balanced Accuracy
binomial_metrics(all = TRUE, balanced_accuracy = FALSE)

# Disable Balanced Accuracy
binomial_metrics(balanced_accuracy = FALSE)
}
}
\seealso{
Other evaluation functions: 
\code{\link{confusion_matrix}()},
\code{\link{evaluate_residuals}()},
\code{\link{evaluate}()},
\code{\link{gaussian_metrics}()},
\code{\link{multinomial_metrics}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{evaluation functions}
