% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{sum_tile_settings}
\alias{sum_tile_settings}
\title{Create a list of settings for the sum tiles in plot_confusion_matrix()}
\usage{
sum_tile_settings(
  palette = NULL,
  label = NULL,
  tile_fill = NULL,
  font_color = NULL,
  tile_border_color = NULL,
  tile_border_size = NULL,
  tile_border_linetype = NULL,
  tc_tile_fill = NULL,
  tc_font_color = NULL,
  tc_tile_border_color = NULL,
  tc_tile_border_size = NULL,
  tc_tile_border_linetype = NULL
)
}
\arguments{
\item{palette}{Color scheme to use for sum tiles.
 Should be different from the \code{`palette`} used for the regular tiles.

 Passed directly to \code{`palette`} in
 \code{\link[ggplot2:scale_fill_distiller]{ggplot2::scale_fill_distiller}}.

 Try these palettes: \code{"Greens"}, \code{"Oranges"}, \code{"Greys"},
 \code{"Purples"}, \code{"Reds"}, and \code{"Blues"}.

 Note: When \code{`tile_fill`} is specified, the \code{`palette`} is \strong{ignored}.}

\item{label}{The label to use for the sum column and the sum row.}

\item{tc_tile_fill, tile_fill}{Specific background color for the tiles. Passed as \emph{\code{`fill`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.

 If specified, the \code{`palette`} is ignored.}

\item{tc_font_color, font_color}{Color of the text in the tiles with the column and row sums.}

\item{tc_tile_border_color, tile_border_color}{Color of the tile borders. Passed as \emph{\code{`colour`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}

\item{tc_tile_border_size, tile_border_size}{Size of the tile borders. Passed as \emph{\code{`size`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}

\item{tc_tile_border_linetype, tile_border_linetype}{Linetype for the tile borders. Passed as \emph{\code{`linetype`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}
}
\value{
List of settings.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates a list of settings for plotting the column/row sums
 in \code{\link[cvms:plot_confusion_matrix]{plot_confusion_matrix()}}.

 The \code{`tc_`} in the arguments refers to the \strong{total count} tile.

 NOTE: This is very experimental and will likely change.
}
\seealso{
Other plotting functions: 
\code{\link{font}()},
\code{\link{plot_confusion_matrix}()},
\code{\link{plot_metric_density}()},
\code{\link{plot_probabilities_ecdf}()},
\code{\link{plot_probabilities}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{plotting functions}
