% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_formula.R
\name{simplify_formula}
\alias{simplify_formula}
\title{Simplify formula with inline functions}
\usage{
simplify_formula(formula, data = NULL, string_out = FALSE)
}
\arguments{
\item{formula}{Formula object.

 If a string is passed, it will be converted with \code{\link[stats:as.formula]{as.formula()}}.

 When a side \emph{only} contains a \code{NULL}, it is kept. Otherwise \code{NULL}s are removed.

 An intercept (\code{1}) will only be kept if there are no variables on that side of the formula.}

\item{data}{Data frame. Used to extract variables when the formula contains a "\code{.}".}

\item{string_out}{Whether to return as a string. (Logical)}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Extracts all variables from a formula object and creates
 a new formula with all predictor variables added together without the
 inline functions.

 E.g.:

 \code{y ~ x*z + log(a) + (1|b)}

 becomes

 \code{y ~ x + z + a + b}.

 This is useful when passing a formula to \code{\link[recipes:recipe]{recipes::recipe()}}
 for preprocessing a dataset, as used in the
 \code{\link[cvms:preprocess_functions]{preprocess_functions()}}.
}
\examples{
# Attach cvms
library(cvms)

# Create formula
f1 <- "y ~ x*z + log(a) + (1|b)"

# Simplify formula (as string)
simplify_formula(f1)

# Simplify formula (as formula)
simplify_formula(as.formula(f1))
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
