% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ParameterSet.R
\name{parameter_set}
\alias{parameter_set}
\alias{ParameterSet-class}
\alias{parameter_set-class}
\title{Set of model parameters}
\usage{
parameter_set(model, param = list(), tag = NA_character_)
}
\arguments{
\item{model}{\code{character}, a string containing a model name, e.g. \code{"GUTS-RED-IT"}}

\item{param}{named \code{list} of model parameters}

\item{tag}{\code{character}, an optional identifier}
}
\value{
an S4 object of type \linkS4class{ParameterSet}
}
\description{
Set of model parameters
}
\section{Slots}{

\describe{
\item{\code{model}}{\code{character}, a string containing a model name, e.g. \code{"GUTS-RED-IT"}}

\item{\code{tag}}{\code{character}, an optional identifier}

\item{\code{param}}{named \code{list} of model parameters}
}}

\examples{
# create a parameter set and assign it
ps <- parameter_set("GUTS-RED-IT", list(kd=0.12, hb=0.3))
GUTS_RED_IT() \%>\% set_param(ps)

# multiple scenarios can be modified at once
c(GUTS_RED_IT(), GUTS_RED_IT()) \%>\%
  set_param(ps)

# model names must match, otherwise an error will be raised
try(GUTS_RED_SD() \%>\% set_param(ps))
}
