% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose_response.R
\name{dose_response}
\alias{dose_response}
\title{Calculate a dose response curve}
\usage{
dose_response(
  scenario,
  range = c(1, 99),
  n = 20,
  strategy = c("exponential", "decadic", "vanilla"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{scenario}{\code{EffectScenario} used for calculation}

\item{range}{numeric vector specifying the required range of effect levels in percent (\%), defaults to \code{c(1,99)}}

\item{n}{minimum number of points on the dose response curve}

\item{strategy}{controls how multiplication factors are chosen, \code{vanilla} uses a fixed
set of multiplication factors, \code{decadic} and \code{exponential} have varying step lengths
if this is feasible depends on the environment setup as defined by the \code{future} package}

\item{verbose}{logical, set to \code{TRUE} for additional status messages}

\item{...}{additional arguments passed on to \code{\link[=effect]{effect()}}}
}
\value{
\code{data.frame} with two columns, i.e. \code{factor} and \code{effect}
}
\description{
Returns a \code{data.frame} with points on the dose response curve for the given
effect scenario.
}
\details{
Derives a dose response curve from a \link{scenario}. The result will
cover the requested range of effect levels. The tested multiplication factors
can be chosen by different strategies, i.e. a \code{vanilla} approach using a
fixed set of factors, or \code{decadic} and \code{exponential} approaches
employing logarithmic and exponential factor scaling, respectively.
}
\examples{
# basic dose response curve
minnow_sd \%>\% dose_response()

# modify the minimum number of points on the curve
minnow_sd \%>\% dose_response(n=10)

# select a subset of the effect range
minnow_sd \%>\% dose_response(range=c(10,20))

# use an alternative strategy for the selection of multiplication factors
minnow_sd \%>\% dose_response(strategy="decadic")

# provide additional output how multiplication factors were selected
minnow_sd \%>\% dose_response(verbose=TRUE)
}
