% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Algae.R
\name{Algae_Simple}
\alias{Algae_Simple}
\alias{AlgaeSimpleScenario-class}
\title{Algae model with exponential growth but without additional forcings}
\usage{
Algae_Simple()
}
\value{
an S4 object of type \linkS4class{AlgaeSimpleScenario}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. It follows the concept of a simplified algae model
described in Rendal et al. (2023). The model simulates the development of
algal biomass. The growth of the algae population is simulated on the basis
of growth rates, which are, in contrast to the Weber model, independent on
environmental conditions which are usually optimal in laboratory effect studies.
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances through a corresponding reduction in the photosynthesis rate on the
basis of internal concentrations.
}
\section{State variables}{

The model has two state variables:
\itemize{
\item \code{A}, Biomass
\item \code{Dw}, only used if scaled = 1
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
\item \code{const_growth}, constant growth over time (0 = no, 1 = yes)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (ug L-1)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
\item \code{dose_response}, shape of the dose response curve (0 = logit, 1 = probit)
}
\item External concentration (Toxicokinetics)
\itemize{
\item \code{kD}, dominant rate constant of toxicant in aquatic environments (d-1)
\item \code{scaled}, 0 = no internal scaled damage / 1 = yes (-)
}
}
}

\section{Forcings}{

simplified model without additional forcings except the external concentration
and a forcing variable f_growth if the growth rates are time-dependent. If
not time dependent, f_growth should be set to 1.
}

\section{Simulation output}{


Simulation results will contain state variables.
}

\references{
Weber D, Schaeffer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31, 899-908. \doi{10.1002/etc.1765}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_TKTD}()},
\code{\link{Algae_Weber}()}
}
\concept{algae models}
