% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Algae.R
\name{Algae_Weber}
\alias{Algae_Weber}
\alias{AlgaeWeberScenario-class}
\title{Algae model with exponential growth and forcings (I, T)}
\usage{
Algae_Weber()
}
\value{
an S4 object of type \linkS4class{AlgaeWeberScenario}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. The model simulates the development of algal biomass
under laboratory and environmental conditions and was developed by
Weber et al. (2012) as cited in EFSA TKTD opinion (2018). The growth of the
algae population is simulated on the basis of growth rates, which are
dependent on environmental conditions (radiation, temperature and phosphorus).
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances through a corresponding reduction in the photosynthesis rate on
the basis of internal concentrations.
}
\section{State variables}{

The model has four state variables:
\itemize{
\item \code{A}, Biomass (ug fresh wt)
\item \code{Q}, Mass of phosphorous internal (mg P/ug fresh wt)
\item \code{P}, Mass of phosphorous external (mg P/L)
\item \code{C}, external substance concentration (ug/L)
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
\item \code{Q_min}, Minimum intracellular P (mg P/ug fresh wt)
\item \code{Q_max}, Maximum intracellular P (mg P/ug fresh wt)
\item \code{v_max}, Maximum P-uptake rate at non-limited growth (mg P/ug fresh wt/d)
\item \code{k_s},   Half-saturation constant for extracellular P (mg P/L)
\item \code{m_max}, Natural mortality rate (1/d)
\item \code{I_opt}, Optimum light intensity for growth (uE/m²/s)
\item \code{T_opt}, Optimum temperature for growth (°C)
\item \code{T_max}, Maximum temperature for growth (°C)
\item \code{T_min}, Minimum temperature for growth (°C)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (ug/L)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
}
\item External concentration (Toxicokinetics)
\itemize{
\item \code{k}, Degradation rate of toxicant in aquatic environments (d-1)
}
}
}

\section{Forcings}{

Besides exposure events (C_in), the \emph{Algae} model requires three environmental
properties as time-series input: Irradiance (\code{I}, uE/m²/s)
and temperature (\code{T_act}, deg C).
Forcings time-series are represented by \code{data.frame} objects
consisting of two columns. The first for time and the second for the
environmental factor in question. The input format for all forcings is a
list of the data frames.
}

\section{Simulation output}{


Simulation results will contain state variables.
}

\references{
Weber D, Schaeffer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31, 899-908. \doi{10.1002/etc.1765}

EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, Brock T, Duquesne S, Grilli S,
Hernandez-Jerez AF, Bennekou SH,Klein M, Kuhl T, Laskowski R, Machera K,
Pelkonen O, Pieper S, Smith RH, Stemmer M, Sundh I, Tiktak A,Topping CJ,
Wolterink G, Cedergreen N, Charles S, Focks A, Reed M, Arena M, Ippolito A,
Byers H andTeodorovic I, 2018. Scientific Opinion on the state of the art of
Toxicokinetic/Toxicodynamic (TKTD)effect models for regulatory risk assessment
of pesticides for aquatic organisms. EFSA Journal, 16(8), 5377.
\doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_Simple}()},
\code{\link{Algae_TKTD}()}
}
\concept{algae models}
