% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{poetEst}
\alias{poetEst}
\title{POET Estimator}
\usage{
poetEst(dat, k, lambda)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{k}{An \code{integer} indicating the number of unobserved latent
factors. Empirical evidence suggests that the POET estimator is robust to
overestimation of this hyperparameter \insertCite{fan2013}{cvCovEst}. In
practice, it is therefore preferable to use larger values.}

\item{lambda}{A non-negative \code{numeric} defining the amount of
thresholding applied to each element of sample covariance matrix's
orthogonal complement.}
}
\value{
A \code{matrix} corresponding to the estimate of the covariance
matrix.
}
\description{
\code{poetEst()} implements the Principal Orthogonal complEment
Thresholding (POET) estimator, a nonparametric, unobserved-factor-based
estimator of the covariance matrix \insertCite{fan2013}{cvCovEst}. The
estimator is defined as the sum of the sample covariance matrix'
rank-\code{k} approximation and its post-thresholding principal orthogonal
complement. The hard thresholding function is used here, though others
could be used instead.
}
\examples{
poetEst(dat = mtcars, k = 2L, lambda = 0.1)
}
\references{
\insertAllCited{}
}
