% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_metric.R
\name{add_metric}
\alias{add_metric}
\title{Add metrics to a cutpointr or roc_cutpointr object}
\usage{
add_metric(object, metric)
}
\arguments{
\item{object}{A cutpointr or roc_cutpointr object.}

\item{metric}{(list) A list of metric functions to be added.}
}
\value{
A cutpointr or roc_cutpointr object (a data.frame) with one or more added columns.
}
\description{
By default, the output of cutpointr includes the optimized metric and several
other metrics. This function adds further metrics. Suitable metric functions
are all metric functions that are included in the package or that comply
with those standards.
}
\examples{
library(dplyr)
library(cutpointr)
cutpointr(suicide, dsi, suicide, gender) \%>\%
  add_metric(list(ppv, npv)) \%>\%
  select(optimal_cutpoint, subgroup, AUC, sum_sens_spec, ppv, npv)
}
\seealso{
Other main cutpointr functions: \code{\link{boot_ci}},
  \code{\link{boot_test}}, \code{\link{cutpointr}},
  \code{\link{multi_cutpointr}},
  \code{\link{predict.cutpointr}}, \code{\link{roc}}
}
\concept{main cutpointr functions}
