% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{total_utility}
\alias{total_utility}
\title{Calculate the total utility}
\usage{
total_utility(tp, fp, tn, fn, utility_tp = 1, utility_tn = 1, cost_fp = 1,
  cost_fn = 1, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{utility_tp}{(numeric) the utility of a true positive}

\item{utility_tn}{(numeric) the utility of a true negative}

\item{cost_fp}{(numeric) the cost of a false positive}

\item{cost_fn}{(numeric) the cost of a false negative}

\item{...}{for capturing additional arguments passed by method.}
}
\description{
Calculate the total utility from
true positives, false positives, true negatives and false negatives. \cr \cr
total_utility = utility_tp * tp + utility_tn * tn - cost_fp * fp - cost_fn * fn \cr \cr
The inputs must be vectors of equal length.
}
\examples{
total_utility(10, 5, 20, 10, utility_tp = 3, utility_tn = 3, cost_fp = 1, cost_fn = 5)
total_utility(c(10, 8), c(5, 7), c(20, 12), c(10, 18),
              utility_tp = 3, utility_tn = 3, cost_fp = 1, cost_fn = 5)
}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cohens_kappa}}, \code{\link{cutpoint}},
  \code{\link{false_omission_rate}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{sensitivity}},
  \code{\link{specificity}}, \code{\link{sum_ppv_npv}},
  \code{\link{sum_sens_spec}}, \code{\link{tpr}},
  \code{\link{tp}}, \code{\link{youden}}
}
