% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlearm_functions.R
\name{findSingleSimonDesign}
\alias{findSingleSimonDesign}
\title{Find a single Simon design}
\usage{
findSingleSimonDesign(n1, n2, r1, r, p0, p1)
}
\arguments{
\item{n1}{Number of participants in stage 1}

\item{n2}{Number of participants in stage 2}

\item{r1}{Interim stopping boundary that must be exceeded to avoid no go stopping}

\item{r}{Final rejection boundary that must be exceeded to reject the null hypothesis.}

\item{p0}{Anticipated response probability for inefficacious treatment}

\item{p1}{Anticipated response probability for efficacious treatment}
}
\value{
A vector containing all the inputted values and corresponding operating characteristics.
}
\description{
This function finds the operating characteristics of a single realisation of a Simon design. It returns
the inputted values along with the type-I error-rate (alpha), power,  expected sample size under p=p0 (EssH0)
and expected sample size under p=p1 (Ess).
}
\examples{
findSingleSimonDesign(n1 = 15, n2 = 11, r1 = 1, r = 4, p0 = 0.1, p1 = 0.3)
}
\references{
\doi{10.1016/0197-2456(89)90015-9}{Richard Simon,
Optimal two-stage designs for phase II clinical trials,
Controlled Clinical Trials,
Volume 10, Issue 1,
1989,
Pages 1-10}
}
\author{
Martin Law, \email{martin.law@mrc-bsu.cam.ac.uk}
}
