% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_cuperdec}
\alias{plot_cuperdec}
\title{Plot cumulative percent decay curves}
\usage{
plot_cuperdec(curves, metadata, burnin_result, restrict_x = 0)
}
\arguments{
\item{curves}{Output tibble from \code{\link{calculate_curve}}.}

\item{metadata}{Optional output from \code{\link{load_map}}.}

\item{burnin_result}{Optional output from \code{apply_*_burnin}.
functions.}

\item{restrict_x}{Optional restriction viewing of abundance rank to X number
of ranks (useful for closer inspection of curves).}
}
\value{
A ggplot2 image object.
}
\description{
Generates visual representation of curves, with optional separate plotting
of different groups, and also indication of individuals passing different
on types filters.
}
\examples{
data(cuperdec_taxatable_ex)
data(cuperdec_database_ex)
data(cuperdec_metadata_ex)

taxa_table <- load_taxa_table(cuperdec_taxatable_ex)
iso_database <- load_database(cuperdec_database_ex, target = "oral")
metadata_table <- load_map(cuperdec_metadata_ex,
  sample_col = "#SampleID",
  source_col = "Env"
)

curves <- calculate_curve(taxa_table, iso_database)
burnin_results <- adaptive_burnin_filter(curves, percent_threshold = 0.1)

plot_cuperdec(curves, metadata_table, burnin_results)
}
