% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.gfcm.R
\name{predict.gfcm}
\alias{predict.gfcm}
\title{Predict function for flexible mixture cure model}
\usage{
\method{predict}{gfcm}(object, newdata = NULL,
        type = c("surv", "curerate", "probcure", "survuncured",
        "hazarduncured", "cumhazuncured", "densityuncured",
        "failuncured", "oddsuncured", "loghazarduncured","hazard",
        "density", "fail", "loghazard", "odds", "cumhaz"), indi = TRUE,
        time = NULL, var.type = c("ci", "se", "n"), pars = NULL,
        link = NULL, keep.attributes = FALSE, \dots)
}
\arguments{
\item{object}{Object of class \code{gfcm} to do predictions from.}

\item{newdata}{Data frame from which to compute predictions. If empty, predictions are made on the data which
the model was fitted on.}

\item{type}{Prediction type (see details). The default is \code{surv}.}

\item{indi}{Logical. If \code{TRUE}, each line in \code{newdata} is treated as an individual observations. This
functionality allows predictions for each observation at more than one time point.}

\item{time}{Optional time points at which to compute predictions.
This argument is not used if type is \code{curerate}.}

\item{var.type}{Character. Possible values are "\code{ci}" (default) for confidence intervals,
"\code{se}" for standard errors, and "\code{n}" for neither.}

\item{pars}{Numerical vector containing the parameters values of the model.
In general, this argument can be ignored by the user.}

\item{link}{Character, indicating the link function for the variance calculations.
Possible values are "\code{log}", "\code{cloglog}" for \eqn{log(-log(x))} , "\code{mlog}" for -log(x),
and "\code{I}" for the indentity.
If \code{NULL} (default), the function will determine \code{link} from \code{type}.}

\item{keep.attributes}{Logical. If \code{TRUE}, \code{newdata} will be added to the attributes of the output.}

\item{...}{Additional arguments. Currently not used.}
}
\value{
A list containing the predictions of each individual in \code{newdata}.
}
\description{
Function for doing predictions for class \code{gfcm}.
}
\details{
Possible values for argument \code{type} are:\cr
\code{surv}: Survival function\cr
\code{curerate}: The cure fraction\cr
\code{probcure}: The conditional probability of being cured\cr
\code{survuncured}: The survival of the uncured\cr
\code{hazarduncured}: The hazard function of the uncured\cr
\code{cumhazuncured}: The cumulative hazard of the uncured\cr
\code{densityuncured}: The density function of the uncured\cr
\code{failuncured}: The distribution function of the uncured, i.e., 1 - \code{survuncured}\cr
\code{oddsuncured}: Odds of the uncured, i.e., (1 - \code{survuncured}) / \code{survuncured}\cr
\code{loghazarduncured}: The log-hazard of the uncured\cr
\code{hazard}: The hazard function\cr
\code{density}: The density function\cr
\code{fail}: The distribution function\cr
\code{loghazard}: The log-hazard function\cr
\code{odds}: The odds, i.e., (1 - \code{surv}) / \code{surv}\cr
\code{cumhaz}: The cumulative hazard function
}
