% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{chemical_equal_batch}
\alias{chemical_equal_batch}
\title{Chemical equal batch search}
\usage{
chemical_equal_batch(
  word_list = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{word_list}{A list of character strings of chemical names or portion of
chemical names, DTXSIDs, CASRNs, InChIKeys.}

\item{API_key}{User-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames of chemicals and related values matching
the query parameters
}
\description{
Chemical equal batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemicals that match input strings
bpa <- chemical_equal_batch(word_list = c('DTXSID7020182', 'DTXCID30182'))
\dontshow{\}) # examplesIf}
}
