% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdpcor2cov.R
\name{sdpcor2cov}
\alias{sdpcor2cov}
\title{sdcor2cov}
\usage{
sdpcor2cov(mat, coronly = FALSE, cholesky = FALSE)
}
\arguments{
\item{mat}{input square matrix with std dev on diagonal and lower tri of partial correlations.}

\item{coronly}{if TRUE, ignores everything except the lower triangle and outputs correlation.}

\item{cholesky}{Logical. To return the cholesky decomposition instead of full covariance, set to TRUE.}
}
\description{
Converts a lower triangular matrix with standard deviations on the diagonal and partial correlations on
lower triangle, to a covariance (or cholesky decomposed covariance)
}
\examples{
testmat <- diag(exp(rnorm(5,-3,2)),5) #generate arbitrary std deviations
testmat[row(testmat) > col(testmat)] <- runif((5^2-5)/2, -1, 1) 
print(testmat)
covmat <- sdpcor2cov(testmat) #convert to covariance
cov2cor(covmat) #convert covariance to correlation
}
