% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctKalman.R
\name{plot.ctKalmanDF}
\alias{plot.ctKalmanDF}
\title{Plots Kalman filter output from ctKalman.}
\usage{
\method{plot}{ctKalmanDF}(x, subjects = 1, kalmanvec = c("y",
  "ysmooth"), errorvec = "auto", errormultiply = 1.96, plot = TRUE,
  elementNames = NA, polygonsteps = 20, polygonalpha = 0.3, ...)
}
\arguments{
\item{x}{Output from \code{\link{ctKalman}}. In general it is easier to call 
\code{\link{ctKalman}} directly with the \code{plot=TRUE} argument, which calls this function.}

\item{subjects}{vector of integers denoting which subjects (from 1 to N) to plot predictions for.}

\item{kalmanvec}{string vector of names of any elements of the output you wish to plot, 
the defaults of 'y' and 'ysmooth' plot the original data, 'y', 
and the estimates of the 'true' value of y given all data. Replacing 'y' by 'eta' will 
plot latent states instead (though 'eta' alone does not exist) and replacing 'smooth' 
with 'upd' or 'prior' respectively plots updated (conditional on all data up to current time point)
or prior (conditional on all previous data) estimates.}

\item{errorvec}{vector of names indicating which kalmanvec elements to plot uncertainty bands for. 
'auto' plots all possible.}

\item{errormultiply}{Numeric denoting the multiplication factor of the std deviation of errorvec objects. 
Defaults to 1.96, for 95\% intervals.}

\item{plot}{if FALSE, plots are not generated and the ggplot object is simply returned invisibly.}

\item{elementNames}{if NA, all relevant object elements are included -- e.g. if yprior is in the kalmanvec
argument, all manifest variables are plotted, and likewise for latent states if etasmooth was specified.
Alternatively, a character vector specifying the manifest and latent names to plot explicitly can be specified.}

\item{polygonsteps}{Number of steps to use for uncertainty band shading.}

\item{polygonalpha}{Numeric for the opacity of the uncertainty region.}

\item{...}{not used.}
}
\value{
A ggplot2 object. Side effect -- Generates plots.
}
\description{
Plots Kalman filter output from ctKalman.
}
\examples{
\donttest{
### Get output from ctKalman
x<-ctKalman(ctstantestfit,subjects=2,timestep=.01)

### Plot with plot.ctKalman
plot.ctKalmanDF(x, subjects=2)

###Single step procedure:
ctKalman(ctstantestfit,subjects=2,
  kalmanvec=c('y','yprior'),
  elementNames=c('Y1','Y2'), 
  plot=TRUE,timestep=.01)
}
}
