% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctGenerateFromFit.R
\name{ctGenerateFromFit}
\alias{ctGenerateFromFit}
\title{Generates data according to the model estimated in a ctsemFit object.}
\usage{
ctGenerateFromFit(fit, timestep = "asdata", n.subjects = 100,
  timerange = "asdata", predictorSubjects = "all", ...)
}
\arguments{
\item{fit}{object of class ctsemFit as returned from \code{\link{ctFit}}}

\item{timestep}{positive numeric value indicating the time interval to use for
data generation.}

\item{n.subjects}{integer. Number of subjects worth of data to generate}

\item{timerange}{either 'asdata' to calculate range based on data in fit object,
or vector of length 2 specifying min and max times for generation.}

\item{predictorSubjects}{vector of integers, or string 'all', defining which 
subjects to sample time dependent and independent predictors from.}

\item{...}{parameters to pass to ctGenerate function, such as wide=FALSE.}
}
\value{
matrix of generated data
}
\description{
Generates data according to the model estimated in a ctsemFit object.
}
\examples{

data(AnomAuth) 
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2), 
  Tpoints = 5, n.latent = 2, n.manifest = 2, MANIFESTVAR=diag(0, 2)) 
AnomAuthfit <- ctFit(AnomAuth, AnomAuthmodel)

dwide <- ctGenerateFromFit(AnomAuthfit,timestep=1,n.subjects=5)

par(mfrow=c(1,2))
ctIndplot(datawide = dwide,n.subjects = 5,n.manifest = 2,vars=1,Tpoints = 4)
ctIndplot(datawide = AnomAuth+rnorm(length(AnomAuth)),vars=1,n.subjects = 5,
n.manifest = 2,Tpoints = 4)

}
