% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_sponsorType.R
\name{f.sponsorType}
\alias{f.sponsorType}
\title{Calculate type of control data collected in a study}
\usage{
f.sponsorType(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.sponsorType`, which is
a factor with levels `For profit`, `Not for profit` or `Other`.
}
\description{
Trial concept calculated: type or class of the lead or main sponsor of the
trial. Some information is not yet mapped (e.g., "NETWORK" in CTGOV2).
No specific field is available in ISRCTN.
}
\examples{
# fields needed
f.sponsorType()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.sponsorType",
  con = dbc)
trialsDf

}
