% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrOpenSearchPagesInBrowser.R
\name{ctrOpenSearchPagesInBrowser}
\alias{ctrOpenSearchPagesInBrowser}
\title{Open register to show query results or search page}
\usage{
ctrOpenSearchPagesInBrowser(url = "", register = "", copyright = FALSE)
}
\arguments{
\item{url}{of search results page to show in the browser. To open the
browser with a previous search, the output of \link{ctrGetQueryUrl}
or \link{dbQueryHistory} can be used. Can be left as empty string
(default) to open the advanced search page of \code{register}.}

\item{register}{Register(s) to open, "EUCTR", "CTGOV2",
"ISRCTN" or "CTIS". Default is empty string, and this opens the
advanced search page of the register(s).}

\item{copyright}{(Optional) If set to \code{TRUE}, opens only the
copyright pages of all registers.}
}
\value{
(String) Full URL corresponding to the shortened \code{url}
  in conjunction with \code{register} if any, or invisibly
  \code{TRUE} if no \code{url} is specified.
}
\description{
Open advanced search pages of register(s), or execute search in browser
}
\examples{

# Open all and check copyrights before using registers
ctrOpenSearchPagesInBrowser(copyright = TRUE)

# Open specific register advanced search page
ctrOpenSearchPagesInBrowser(register = "CTGOV2")
ctrOpenSearchPagesInBrowser(register = "CTIS")
ctrOpenSearchPagesInBrowser(register = "EUCTR")
ctrOpenSearchPagesInBrowser(register = "ISRCTN")

# Open all queries that were loaded into demo collection
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials",
  flags = RSQLite::SQLITE_RO)

dbh <- dbQueryHistory(con = dbc)

for (r in seq_len(nrow(dbh))) {
    ctrOpenSearchPagesInBrowser(dbh[r, ])
}

}
