% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfTrials2Long.R
\name{dfTrials2Long}
\alias{dfTrials2Long}
\title{Convert data frame with trial records into long format}
\usage{
dfTrials2Long(df)
}
\arguments{
\item{df}{Data frame (or tibble) with columns including
the trial identifier (\code{_id}) and
one or more variables as obtained from
\link{dbGetFieldsIntoDf}}
}
\value{
A data frame  (or tibble, if \code{tibble} is loaded)
with the four columns: `_id`, `identifier`, `name`, `value`
}
\description{
The function works with procotol- and results- related information.
It converts lists and other values that are in a data frame returned
by \link{dbGetFieldsIntoDf} into individual rows of a long data frame.
From the resulting long data frame, values of interest can be selected
using \link{dfName2Value}.
The function is particularly useful for fields with complex content,
such as node field "\code{clinical_results}" from EUCTR, for which
\link{dbGetFieldsIntoDf} returns as a multiply nested list and for
which this function then converts every observation of every (leaf)
field into a row of its own.
}
\examples{

dbc <- nodbi::src_sqlite(
   dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
   collection = "my_trials",
   RSQLite::SQLITE_RO)

dfwide <- dbGetFieldsIntoDf(
  fields = "clinical_results.participant_flow",
  con = dbc)

dfTrials2Long(df = dfwide)

}
