% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFindFields.R
\name{dbFindFields}
\alias{dbFindFields}
\title{Find names of fields in the database collection}
\usage{
dbFindFields(namepart = ".*", con, sample = TRUE, verbose = FALSE)
}
\arguments{
\item{namepart}{A character string (can be a regular expression,
including Perl-style) to be searched among all field names (keys)
in the collection, case-insensitive. The default `".*"` lists all fields.}

\item{con}{A connection object, see section
`Databases` in \link{ctrdata}.}

\item{sample}{If \code{TRUE} (default), uses a sample of only 5 trial
records per register to identify fields, to rapidly return a possibly
incomplete set of field names.
If \code{FALSE}, uses all trial records in the collection, which will
take more time with more trials but ensures to returns all names of
all fields in the collection.}

\item{verbose}{If \code{TRUE}, prints additional information
(default \code{FALSE}).}
}
\value{
Vector of strings with full names of field(s) found,
ordered by register and alphabet, see examples. Names of the vector
are the names of the register holding the respective fields. The field
names can be fed into \link{dbGetFieldsIntoDf} to extract the
data for the field(s) from the collection into a data frame.
}
\description{
Given part of the name of a field of interest to the user, this
function returns the full field names used in records that were
previously loaded into a collection
(using \link{ctrLoadQueryIntoDb}). Only names of fields that have
a value in the collection can be returned.
Set \code{sample = FALSE} to force screening all records in the
collection for field names, see below.
}
\details{
The full names of child fields are returned in dot notation (e.g.,
\code{clinical_results.outcome_list.outcome.measure.class_list.class.title})
In addition, names of parent fields (e.g.,
\code{clinical_results}) are returned.
Data in parent fields is typically complex (nested), see
\link{dfTrials2Long} for easily handling it.
For field definitions of the registers, see
"Definition" in \link{ctrdata-registers}.
Note: When \code{dbFindFields} is first called after
\link{ctrLoadQueryIntoDb}, it will take a moment.
}
\examples{

dbc <- nodbi::src_sqlite(
    dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
    collection = "my_trials"
)

dbFindFields(namepart = "date", con = dbc)[1:5]

# view all 3350+ fields from all registers:

allFields <- dbFindFields(con = dbc, sample = FALSE)

if (interactive()) View(data.frame(
  register = names(allFields),
  field = allFields))

}
