% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbQueryHistory}
\alias{dbQueryHistory}
\title{Show history of queries loaded into a database collection}
\usage{
dbQueryHistory(con, verbose = FALSE)
}
\arguments{
\item{con}{A connection object, see section
`Databases` in \link{ctrdata-package}.}

\item{verbose}{If \code{TRUE}, prints additional information
(default \code{FALSE}).}
}
\value{
A data frame (or tibble, if \code{dplyr} is loaded)
 with columns: `query-timestamp`, `query-register`,
 `query-records` (note: this is the number of records loaded when last
 executing \link{ctrLoadQueryIntoDb}, not the total record number) and
 `query-term`, with one row for each time \link{ctrLoadQueryIntoDb}
 loaded trial records into this collection.
}
\description{
Show history of queries loaded into a database collection
}
\examples{

dbc <- nodbi::src_sqlite(
   dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
   collection = "my_trials")

dbQueryHistory(con = dbc)

}
