% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfListExtractKey}
\alias{dfListExtractKey}
\title{Extract named element(s) from list(s) into long-format
data frame}
\usage{
dfListExtractKey(df, list.key = list(c("endPoints.endPoint", "^title")))
}
\arguments{
\item{df}{A data frame}

\item{list.key}{A list of pairs of list names and
key names, where the list name corresponds to the
name of a column in \code{df} that holds a list and
the name of the key identifies the element to be
extracted. See example.}
}
\value{
A data frame in long format with columns
 name (identifying the full path in the data frame,
 "<list>.<key>"), _id (of the trial record), value
 (of name per _id), item (number of value of name
 per _id).
}
\description{
The function uses a name (key) to extract an element
from a list in a data.frame such as obtained with
\link{dbGetFieldsIntoDf}. This helps to simplify
working with nested lists and with complex structures.
}
\examples{

\dontrun{

df <- dbGetFieldsIntoDf(
  fields = c("endPoints.endPoint",
             "subjectDisposition.postAssignmentPeriods"),
  con = con
)
dfListExtractKey <- function(
  df,
  list.key =
    list(
      c("endPoints.endPoint",
        "^title"),
      c("subjectDisposition.postAssignmentPeriods",
        "arms.arm.type.value")
    )
)

}

}
