% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvwr.R
\docType{package}
\name{csvwr}
\alias{csvwr}
\title{csvwr: Read and write CSV on the Web (CSVW)}
\description{
Read and write csv tables annotated with
\href{https://w3c.github.io/csvw/metadata/}{csvw metadata}. This helps to
ensure consistent processing and reduce the amount of manual work needed to
parse and prepare data before it can be used in analysis.
}
\section{Getting started}{


The best place to start is the
\href{../doc/read-write-csvw.html}{Reading and Writing CSVW} vignette.
}

\section{Reading annotated tables}{

\itemize{
\item \code{\link{read_csvw}} Parse a table group
\item \code{\link{read_csvw_dataframe}} Parse a table group and extract the first
data frame
}
}

\section{Writing table annotations}{

\itemize{
\item \code{\link{derive_table_schema}} Derive table schema from a data frame
\item \code{\link{create_metadata}} Create a table group annotation
\item \code{\link{derive_metadata}} Derive an annotation from a csv file
}
}

