% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_geo.R
\name{cso_get_geo}
\alias{cso_get_geo}
\title{Return geographic data as a sf data frame}
\usage{
cso_get_geo(map_data, cache = TRUE, flush_cache = TRUE)
}
\arguments{
\item{map_data}{string. Indicates which shapefile to download. Options are:
\itemize{
  \item "Provinces" OR "p",
  \item "NUTS2",
  \item "NUTS3",
  \item "NUTS2_2011",
  \item "NUTS3_2011",
  \item "Administrative Counties" OR "admin_counties" OR "ac",
  \item "Electoral Divisions" OR "elec_div" OR "ed",
  \item "Small Areas" OR "sa" and
  \item "Gaeltacht" OR "g".
}
Until v0.1.5 "NUTS2" and "NUTS3" gave access to the 2011 dataset.}

\item{cache}{logical. Indicates whether to cache the result using R.cache.
TRUE by default.}

\item{flush_cache}{logical. If TRUE (default) the cache will be checked for old, unused
files. Any files which have not been accessed in the last month will be deleted}
}
\value{
data frame of the requested CSO table.
}
\description{
Retrieves an ESRI shapefile of vector data for Ireland from the cso website
\href{https://www.cso.ie/en/census/census2011boundaryfiles/}{cso.ie} and
returns it as an sf data frame. The data is returned as a zip file, which is
downloaded to and unzipped in a temporary directory.
}
\details{
The map data is from the 2011 census, and is 20m generalised, which offers a
good balance of fidelity and low file size. More datasets, as well as
50m generalised, 100m generalised and ungeneralised versions of the map
files can also be found on the OSi (Ordnance Survey Ireland) website at
\url{https://data-osi.opendata.arcgis.com/search?tags=boundaries}.

The NUTS2 and NUTS3 map files are the updated versions for 2016, including
three NUTS2 regions and the movement of Louth and South Tipperary into new
NUTS3 regions. These files are downloaded directly from the OSi website, as
they are not available on the CSO website, and do not contain the population
and housing data contained in the map files from the CSO website.
}
\examples{
\dontrun{
shp <- cso_get_geo("NUTS2")
}
}
