/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DiffGeometryIndex {
    private SpatialIndex index;
    private DiffGeometryMatcher diffMatcher;
    private boolean splitIntoComponents;
    private Collection featureList;

    public static Collection splitGeometry(Geometry geom, boolean splitIntoComponents) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        if (splitIntoComponents && geom instanceof GeometryCollection) {
            GeometryCollection geomColl = (GeometryCollection)geom;
            GeometryCollectionIterator gci = new GeometryCollectionIterator((Geometry)geomColl);
            while (gci.hasNext()) {
                Geometry component = (Geometry)gci.next();
                if (component instanceof GeometryCollection) continue;
                list.add(component);
            }
        } else {
            list.add(geom);
        }
        return list;
    }

    public DiffGeometryIndex(FeatureCollection fc, DiffGeometryMatcher diffMatcher, boolean splitIntoComponents) {
        this.diffMatcher = diffMatcher;
        this.splitIntoComponents = splitIntoComponents;
        this.buildIndex(fc);
    }

    public boolean hasMatch(Geometry testGeom) {
        this.diffMatcher.setQueryGeometry(testGeom);
        List closeFeatList = this.index.query(this.diffMatcher.getQueryGeometry().getEnvelopeInternal());
        Iterator j = closeFeatList.iterator();
        while (j.hasNext()) {
            FeatureGeometry closeFeat = (FeatureGeometry)j.next();
            if (!this.diffMatcher.isMatch(closeFeat.getGeometry())) continue;
            closeFeat.setMatched(true);
            return true;
        }
        return false;
    }

    private void buildIndex(FeatureCollection fc) {
        this.featureList = new ArrayList();
        this.index = new STRtree();
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature feat = (Feature)i.next();
            Geometry geom = feat.getGeometry();
            Collection list = DiffGeometryIndex.splitGeometry(geom, this.splitIntoComponents);
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Geometry g = (Geometry)j.next();
                FeatureGeometry featGeom = new FeatureGeometry(feat, g);
                this.index.insert(featGeom.getGeometry().getEnvelopeInternal(), (Object)featGeom);
                this.featureList.add(featGeom);
            }
        }
    }

    public Collection getUnmatchedFeatures() {
        TreeSet<Feature> unmatchedFeatureSet = new TreeSet<Feature>(new FeatureUtil.IDComparator());
        Iterator i = this.featureList.iterator();
        while (i.hasNext()) {
            FeatureGeometry fg = (FeatureGeometry)i.next();
            if (fg.isMatched()) continue;
            unmatchedFeatureSet.add(fg.getFeature());
        }
        return unmatchedFeatureSet;
    }

    public class FeatureGeometry {
        private Feature feat;
        private Geometry geom;
        private boolean isMatched = false;

        public FeatureGeometry(Feature feat, Geometry geom) {
            this.feat = feat;
            this.geom = geom;
        }

        public Feature getFeature() {
            return this.feat;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public void setMatched(boolean isMatched) {
            this.isMatched = isMatched;
        }

        public boolean isMatched() {
            return this.isMatched;
        }
    }
}

