/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class SimpleGeometryPrecisionReducer {
    private PrecisionModel newPrecisionModel;
    private boolean removeCollapsed = true;
    private boolean changePrecisionModel = false;

    public SimpleGeometryPrecisionReducer(PrecisionModel pm) {
        this.newPrecisionModel = pm;
    }

    public void setRemoveCollapsedComponents(boolean removeCollapsed) {
        this.removeCollapsed = removeCollapsed;
    }

    public void setChangePrecisionModel(boolean changePrecisionModel) {
        this.changePrecisionModel = changePrecisionModel;
    }

    public Geometry reduce(Geometry geom) {
        GeometryEditor geomEdit;
        if (this.changePrecisionModel) {
            GeometryFactory newFactory = new GeometryFactory(this.newPrecisionModel, geom.getFactory().getSRID());
            geomEdit = new GeometryEditor(newFactory);
        } else {
            geomEdit = new GeometryEditor();
        }
        return geomEdit.edit(geom, new PrecisionReducerCoordinateOperation());
    }

    private class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        private PrecisionReducerCoordinateOperation() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geom) {
            if (coordinates.length == 0) {
                return null;
            }
            Coordinate[] reducedCoords = new Coordinate[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                Coordinate coord = new Coordinate(coordinates[i]);
                SimpleGeometryPrecisionReducer.this.newPrecisionModel.makePrecise(coord);
                reducedCoords[i] = coord;
            }
            CoordinateList noRepeatedCoordList = new CoordinateList(reducedCoords, false);
            Coordinate[] noRepeatedCoords = noRepeatedCoordList.toCoordinateArray();
            int minLength = 0;
            if (geom instanceof LineString) {
                minLength = 2;
            }
            if (geom instanceof LinearRing) {
                minLength = 4;
            }
            Coordinate[] collapsedCoords = reducedCoords;
            if (SimpleGeometryPrecisionReducer.this.removeCollapsed) {
                collapsedCoords = null;
            }
            if (noRepeatedCoords.length < minLength) {
                return collapsedCoords;
            }
            return noRepeatedCoords;
        }
    }
}

