/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;

public class MultiPointHandler
implements ShapeHandler {
    int myShapeType = -1;

    public MultiPointHandler() {
        this.myShapeType = 8;
    }

    public MultiPointHandler(int type) throws InvalidShapefileException {
        if (type != 8 && type != 18 && type != 28) {
            throw new InvalidShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.myShapeType = type;
    }

    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        int fullLength;
        int t;
        int actualReadWords = 0;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            return new MultiPoint(null, new PrecisionModel(), 0);
        }
        if (shapeType != this.myShapeType) {
            throw new InvalidShapefileException("Multipointhandler.read() - expected type code " + this.myShapeType + " but got " + shapeType);
        }
        file.readDoubleLE();
        file.readDoubleLE();
        file.readDoubleLE();
        file.readDoubleLE();
        actualReadWords += 16;
        int numpoints = file.readIntLE();
        actualReadWords += 2;
        Coordinate[] coords = new Coordinate[numpoints];
        for (t = 0; t < numpoints; ++t) {
            double x = file.readDoubleLE();
            double y = file.readDoubleLE();
            actualReadWords += 8;
            coords[t] = new Coordinate(x, y);
        }
        if (this.myShapeType == 18) {
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 8;
            for (t = 0; t < numpoints; ++t) {
                double z = file.readDoubleLE();
                actualReadWords += 4;
                coords[t].z = z;
            }
        }
        if (this.myShapeType >= 18 && contentLength >= (fullLength = this.myShapeType == 18 ? 20 + numpoints * 8 + 8 + 4 * numpoints + 8 + 4 * numpoints : 20 + numpoints * 8 + 8 + 4 * numpoints)) {
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 8;
            for (int t2 = 0; t2 < numpoints; ++t2) {
                file.readDoubleLE();
                actualReadWords += 4;
            }
        }
        while (actualReadWords < contentLength) {
            short junk2 = file.readShortBE();
            ++actualReadWords;
        }
        return geometryFactory.createMultiPoint(coords);
    }

    double[] zMinMax(Geometry g) {
        boolean validZFound = false;
        Coordinate[] cs = g.getCoordinates();
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        for (int t = 0; t < cs.length; ++t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }

    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        int t;
        MultiPoint mp = (MultiPoint)geometry;
        file.writeIntLE(this.getShapeType());
        Envelope box = mp.getEnvelopeInternal();
        file.writeDoubleLE(box.getMinX());
        file.writeDoubleLE(box.getMinY());
        file.writeDoubleLE(box.getMaxX());
        file.writeDoubleLE(box.getMaxY());
        int numParts = mp.getNumGeometries();
        file.writeIntLE(numParts);
        for (t = 0; t < mp.getNumGeometries(); ++t) {
            Coordinate c = mp.getGeometryN(t).getCoordinate();
            file.writeDoubleLE(c.x);
            file.writeDoubleLE(c.y);
        }
        if (this.myShapeType == 18) {
            double[] zExtreame = this.zMinMax((Geometry)mp);
            if (Double.isNaN(zExtreame[0])) {
                file.writeDoubleLE(0.0);
                file.writeDoubleLE(0.0);
            } else {
                file.writeDoubleLE(zExtreame[0]);
                file.writeDoubleLE(zExtreame[1]);
            }
            for (int t2 = 0; t2 < mp.getNumGeometries(); ++t2) {
                Coordinate c = mp.getGeometryN(t2).getCoordinate();
                double z = c.z;
                if (Double.isNaN(z)) {
                    file.writeDoubleLE(0.0);
                    continue;
                }
                file.writeDoubleLE(z);
            }
        }
        if (this.myShapeType >= 18) {
            file.writeDoubleLE(-1.0E41);
            file.writeDoubleLE(-1.0E41);
            for (t = 0; t < mp.getNumGeometries(); ++t) {
                file.writeDoubleLE(-1.0E41);
            }
        }
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        MultiPoint mp = (MultiPoint)geometry;
        if (this.myShapeType == 8) {
            return mp.getNumGeometries() * 8 + 20;
        }
        if (this.myShapeType == 28) {
            return mp.getNumGeometries() * 8 + 20 + 8 + 4 * mp.getNumGeometries();
        }
        return mp.getNumGeometries() * 8 + 20 + 8 + 4 * mp.getNumGeometries() + 8 + 4 * mp.getNumGeometries();
    }
}

