% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_generic.R
\name{format_generic}
\alias{format_generic}
\title{Format a generic transaction file}
\usage{
format_generic(
  data,
  date = "date",
  currency = "currency",
  quantity = "quantity",
  total.price = "total.price",
  spot.rate = "spot.rate",
  transaction = "transaction",
  fees = "fees",
  description = "description",
  comment = "comment",
  revenue.type = "revenue.type",
  exchange = "exchange",
  timezone = "UTC",
  force = FALSE,
  list.prices = NULL
)
}
\arguments{
\item{data}{The dataframe}

\item{date}{The date column}

\item{currency}{The currency column}

\item{quantity}{The quantity column}

\item{total.price}{The total.price column, if available}

\item{spot.rate}{The spot.rate column, if available}

\item{transaction}{The transaction column}

\item{fees}{The fees column, if available}

\item{description}{The description column, if available}

\item{comment}{The comment column, if available}

\item{revenue.type}{The revenue.type column, if available (content can
be one of \code{c("airdrops", "referrals", "staking", "promos", "interests", "rebates", "rewards", "forks", "mining")})}

\item{exchange}{The exchange column}

\item{timezone}{The time zone of the transactions}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}
}
\value{
A data frame of exchange transactions, formatted for further processing.
}
\description{
Format a generic .csv transaction history file. This
function requires one transaction per row, so will not work with
trades of two coins reported on the same row. For this you will
have to split the trade on two rows and have a single currency
column per row.
}
\examples{
# Detects correct names even with capitals
format_generic(data_generic1)

# In other cases, names can be specified explicitly:
format_generic(
  data_generic2,
  date = "Date.Transaction",
  currency = "Coin",
  quantity = "Amount",
  total.price = "Price",
  transaction = "Type",
  fees = "Fee",
  exchange = "Platform"
)

# If total.price is missing, it will calculate it based
# on the spot.rate, if available
format_generic(data_generic3)

# If both total.price and spot.rate are missing, it will
# scrap the spot.rate from coinmarketcap based on the coin:
format_generic(data_generic4)

}
