% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACB.R
\name{ACB}
\alias{ACB}
\title{Calculate capital gains from realized gain transactions}
\usage{
ACB(
  data,
  transaction = "transaction",
  price = "price",
  quantity = "quantity",
  fees = "fees",
  total.price = "total.price",
  spot.rate = "spot.rate",
  as.revenue = c("staking", "interests", "mining"),
  sup.loss = TRUE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{The dataframe}

\item{transaction}{Name of transaction column}

\item{price}{Name of price column}

\item{quantity}{Name of quantity column}

\item{fees}{Name of fees column}

\item{total.price}{Name of total.price column}

\item{spot.rate}{Name of spot.rate column}

\item{as.revenue}{Name of as.revenue column}

\item{sup.loss}{Logical, whether to calculate superficial losses}

\item{cl}{Number of cores to use for parallel processing.}

\item{verbose}{Logical: if \code{FALSE}, does not print progress bar or
warnings to console.}
}
\value{
A data frame, with the following columns: date, transaction,
quantity, price, fees, total.price, total.quantity, ACB, ACB.share,
gains
}
\description{
Calculate realized and unrealized capital gains/losses
}
\examples{
data <- data_adjustedcostbase1
ACB(data, spot.rate = "price", sup.loss = FALSE)
ACB(data, spot.rate = "price")
}
